#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Game and WatchMod01.fsh   by  byt3_m3chanic  
//https://www.shadertoy.com/view/7ddcRj
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/** 
    License: Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License
   
    interface
    06/03/22 | byt3_m3chanic
    
    Just playing around with some flat 2D interface design (mouseable)

*/

#define R iResolution
#define M iMouse
#define T iTime

#define PI2 6.28318530718
#define PI  3.14159265359

// power color
const vec3 tcolor = vec3(0.518,0.933,0.365);

mat2 rot(float g){return mat2(cos(g), sin(g),-sin(g), cos(g));}
float hash21( vec2 p ){return fract(sin(dot(p,vec2(23.43,84.21)))*4832.3234);}

const float scale = 40.;
const float hlfsc = (.435/scale)*scale;

const float N = 10.;
const float SN = 8.;
const int oct = 5;

// @Shane - a very tightly compacted, self-contained version 
// of IQ's 3D value noise function.
//---------------------------------------------------------------
float n3D(vec3 p){
    const vec3 s = vec3(113, 57, 27);
    vec3 ip = floor(p); p -= ip; 
    vec4 h = vec4(0., s.yz, s.y + s.z) + dot(ip, s);
    p = p*p*(3. - 2.*p);
    h = mix(fract(sin(h)*43758.5453), fract(sin(h + s.x)*43758.5453), p.x);
    h.xy = mix(h.xz, h.yw, p.y);
    return mix(h.x, h.y, p.z); // Range: [0, 1].
}
//---------------------------------------------------------------
// @iq fbm generator
float fbm3( in vec3 x) {
    x*=.64;
    x.x = mod(x.x,SN*N);
    x.y = mod(x.y,SN*N);//@mla : shifting the y value from the range [-PI,+PI] to [0,2N]
    x*=.085;
    float a = 0.1,b = .5,f = 2.;
    vec3  d = vec3(0.);
    for (int i = 0; i < oct; ++i) {      
        float n = n3D(f*x);
        a += b*n;
        b *= 0.5;
        f *= 1.8;
    }
	return a;
}

float box(vec2 p, vec2 b) {vec2 d=abs(p)-b;return length(max(d,0.))+min(max(d.x,d.y),0.);}
float rbox(vec2 p, vec2 b, vec4 r ) {
    r.xy = (p.x>0.0)?r.xy : r.zw;
    r.x  = (p.y>0.0)?r.x  : r.y;
    vec2 q = abs(p)-b+r.x;
    return min(max(q.x,q.y),0.0) + length(max(q,0.0)) - r.x;
}

//iq color functions
vec3 hue(float t){ 
    t*=3.125;
    vec3 d = vec3(0.357,0.937,0.043);
    return .65+.4*cos( PI2*t * (vec3(0.945,0.937,0.875)*d) ); 
}

float px = 0.;

vec2 mainSize = vec2(.725,.45);
vec2 insetSize =vec2(.7125,.4375);
vec2 screenSize =vec2(.475,.275);

void nanoBody(inout vec3 C, vec2 p) {
    vec2 uv=p-vec2(0);
    
    //body
    float d = box(uv,mainSize)-.015;
    float sad = d;
    d=smoothstep(px,-px,d);

    //inset
    float i = box(uv,insetSize)-.015;
    i=smoothstep(px,-px,i);
    
    //shadow
    float sd = box(uv+vec2(0,.01),insetSize);
    sd=smoothstep(.045-px,-px,abs(sd)-.01);
    
    //screen
    float d2 = box(uv-vec2(0.,.115),screenSize)-.015;
    float d3 = abs(d2)-.0015;
    float d4 = abs(d2)-.008;
    d2=smoothstep(px,-px,d2);
    d3=smoothstep(px,-px,d3);
    d4=smoothstep(.015-px,-px,d4);
    float hs = hash21(uv*sin(uv.x));
    //red buttons
    px=4./R.x;
    vec2 dv = uv;
    dv.x=abs(dv.x)-.61;
    float btn = length(dv-vec2(.0,-.15))-.065;
    btn=min(btn,rbox(dv+vec2(.185,.25),vec2(.065,.030),vec4(.030)) );
    btn=min(btn,rbox(dv+vec2(.46,.25),vec2(.065,.030),vec4(.030)) );
    btn=smoothstep(px,-px,btn);
    
    vec2 tv = uv*10.;
    float nd = box(vec2(abs(tv.x)-6.1,tv.y-1.7),vec2(.65,1.4));
    //speaker dots
    tv=mod(tv+.1,.2)-.1;
    float dts = length(tv)-.05;
    dts=max(dts,nd);
    dts=smoothstep(px,-px,dts);

    C= mix(C,vec3(.0),sd);
    C= mix(C,vec3(.015)-(hs*.01),d);

    C= mix(C,vec3(.335)-(hs*.01),min(clamp(min(uv.y+.4,i),0.,1.),1.-btn) );
    C= mix(C,vec3(0.208,0.373,0.220)-(hs*.05),d2);
    C= mix(C,C*.5,min(d4,d2));
    C= mix(C,vec3(.6),d3);
    C= mix(C,vec3(.015),dts);
    
    float mcheck = 0.;
    px=2./R.x;
    float ftn = length(dv-vec2(.0,-.15))-.055;
    float rtn=rbox(dv+vec2(.185,.25),vec2(.055,.020),vec4(.020));
    rtn=min(rtn,rbox(dv+vec2(.46,.25),vec2(.055,.020),vec4(.020)) );
    ftn=smoothstep(px,-px,ftn);
    rtn=smoothstep(px,-px,rtn);
    C= mix(C,vec3(.9,.01,.01),ftn);
    C= mix(C,vec3(0.149,0.149,0.149),rtn);
    //button highlight
    float etn = length(dv-vec2(.0,-.15))-.05;
    float een = rbox(dv+vec2(.185,.249),vec2(.050,.015),vec4(.015));
    een=min(een,rbox(dv+vec2(.46,.25),vec2(.050,.015),vec4(.015)) );
    etn=smoothstep(px,-px,etn);
    een=smoothstep(px,-px,een);
    C= mix(C,vec3(1),min(clamp((uv.y*3.25)+.55,0.,1.),etn));
    C= mix(C,vec3(1),min(clamp((uv.y*3.55)+.95,0.,1.),een));
    // power light
    float l = box(uv+vec2(.685,-.42),vec2(.0125,.002))-.0025;
    float sl=smoothstep(.02-px,-px,l);
    l=smoothstep(px,-px,l);
    C= mix(C,tcolor*.2,sl);
    C= mix(C,tcolor,l);

}

const float tx = .5;
const vec2[4] myhood = vec2[4](vec2(1,0),vec2(0,-1),vec2(-1,0),vec2(0,1));
const vec2[4] mypos  = vec2[4](vec2(tx,0),vec2(0,-tx),vec2(-tx,0),vec2(0,tx));

float side(float hs) {
    float s=(hs>.75)?0.:(hs>.5)?2.:(hs>.25)?1.:3.;
    return s;
}

vec3 checkColor(float sd, float fc, vec4 hash) {
    float ch = side(hash[int(fc)]);

    if(sd==0.&&ch==1.||sd==1.&&ch==0.) ch=8.;
    if(sd==0.&&ch==3.||sd==3.&&ch==0.) ch=7.;
    if(sd==0.&&ch==2.||sd==2.&&ch==0.) ch=6.;
    
    if(sd==1.&&ch==3.||sd==3.&&ch==1.) ch=14.;
    if(sd==1.&&ch==2.||sd==2.&&ch==1.) ch=9.;   
  
    if(sd==2.&&ch==3.||sd==3.&&ch==2.) ch=5.;
    
    if(sd==ch) ch=sd;
    
    return vec3(1./ch);
}

vec4 gethood(vec2 id, inout float hs) {
    vec4 nh = vec4(0);
    hs = fbm3(vec3(id,T*2.5));
    for(int i=0;i<4;i++){
        nh[i]=fbm3(vec3(id-myhood[i],T*2.5));
    }
    return nh;
}

void getScreen(inout vec3 C, vec2 p3) {
    vec2 uv=p3;

    //screen
    float srrn = box(uv-vec2(0.,.115),screenSize*.99)-.015;
    srrn=smoothstep(px,-px,srrn);
    
    float px =scale/R.x;
    vec3 clr = vec3(1.);
    uv+=vec2(.0,.1)*T;
    uv-=vec2((M.x/R.x*PI)*1.-.5,(M.y/R.y*PI)*1.-.5);
  
    vec2 id= floor(uv*scale);
    vec2 p = fract(uv*scale)-.5;
    
    float hs = 0.;
    vec4  gs = gethood(id, hs);

    float d1 = box(p,vec2(hlfsc*.89))-.075;
    if(hs>.25){
        float d2 = length(p)-(hs*.3);
        d2=abs(d2)-.02;
        d2=smoothstep(px,-px,d2);
    }
    
    float sd = side(hs);
    d1=smoothstep(px,-px,d1);
    C=mix(C,C*hue(sd),min(d1,srrn));
    
    float sz = .85;

    for(int i=0;i<4;i++){

        vec2 tuv = p+vec2(mypos[i]);
        vec2 bs = i==1||i==3 ? vec2(hlfsc*sz,hlfsc*.25) : vec2(hlfsc*.25,hlfsc*sz);
        d1=box(tuv,bs);

        float s1 = box(tuv-vec2(-.05,.05),bs);
        s1=smoothstep(.15-px,-px,s1);
        
        float od1 = abs(d1)-.015;
        d1=smoothstep(px,-px,d1);
        clr = checkColor(sd,float(i),gs);
        
        // only if edges are different draw overlap
        if(side(gs[i])!=sd){
            C=mix(C,C*.5,min(s1,srrn));
            C=mix(C,clr,min(d1,srrn));
            od1=smoothstep(px,-px,od1);
            C=mix(C,vec3(.01),min(od1,srrn));
        }
    }
}

void rainbow( inout vec3 C, vec2 uv) {
    float hs = hash21(uv*sin(uv.x));
    float s1 = length(abs(uv.y+.04))-.02;
    s1=smoothstep(px,-px,s1);
    C=mix(C,vec3(0.576,0.024,0.161)-(hs*.025),s1);

    s1 = length(abs(uv.y))-.02;
    s1=smoothstep(px,-px,s1);
    C=mix(C,vec3(0.576,0.216,0.024)-(hs*.035),s1);
    
    s1 = length(abs(uv.y-.04))-.02;
    s1=smoothstep(px,-px,s1);
    C=mix(C,vec3(0.678,0.624,0.020)-(hs*.035),s1);
    
    s1 = length(abs(uv.y-.08))-.02;
    s1=smoothstep(px,-px,s1);
    C=mix(C,vec3(0.184,0.553,0.027)-(hs*.025),s1);

    s1 = length(abs(uv.y-.12))-.02;
    s1=smoothstep(px,-px,s1);
    C=mix(C,vec3(0.027,0.220,0.533)-(hs*.035),s1);
}
#define O fragColor
#define F fragCoord
//void mainImage( out vec4 O, in vec2 F )
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  

    vec2 uv = (2.* F.xy-R.xy)/max(R.x,R.y);
    float hs = hash21(uv*sin(uv.x));
    vec3 C = vec3(clamp((uv.y+1.)*.1,.01,1.))-(hs*.015);

    px=2./R.x;

    rainbow(C, uv);
    nanoBody(C, uv);
    getScreen(C,uv);

    if(hs<.65) C = clamp(C-(hs*.005),C,vec3(1));
    C = pow(C, vec3(.4545));
    fragColor = vec4(C,1.);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

